<?php
/**
	* @package Stripe Button Editors-xtd plugin
	* @copyright Copyright (C) 2014 FasterJoomla. All rights reserved.
  *  @license    GNU General Public License version 2, or later
	* @link     https://www.fasterjoomla.com
*/

defined('_JEXEC') or die;
// http://docs.joomla.org/J2.5:Managing_Component_Updates_%28Script.php%29

// works: class PlgEditorsxtdstripe_xtdInstallerScript
// works: class PlgEditorsxtdStripe_xtdInstallerScript
// works: class Plgeditorsxtdstripe_xtdInstallerScript
class Plgeditorsxtdstripe_xtdInstallerScript
//class PlgEditorsxtdStripe_xtdInstallerScript
{
	function postflight( $type, $parent ) {
		$manifest = JPATH_SITE.'/plugins/editors-xtd/stripe_xtd/stripe_xtd.xml';
		$app = JFactory::getApplication();
			// let's see if the plugin is really installed:
				// the manifest contains the string:
				// <version>1.8.6</version>

		if (file_exists($manifest)) {
			if ( ($type == 'install') ) {
					return $this->enablePlugin('stripe_xtd', 'editors-xtd');
			} else if ( ($type == 'update') ) {
					return true; //return $this->enablePlugin('stripe_xtd', 'editors-xtd');
			}
		} else {
			$app->enqueueMessage("Plugin System Stripe editors button not found");
			return false;
		}
	}

	/**
	 * Move $newPluginName just before $nextPluginName
	 *
	 * @param [type] $newPluginName
	 * @param [type] $pluginFolder
	 * @param [type] $nextPluginName
	 * @param [type] $reportOnly => don't move, just print status and warnings
	 * @return void
	 */

	function enablePlugin($pluginName, $pluginFolder) {
		$app = JFactory::getApplication();
		$db = JFactory::getDbo();
		$query = "select * FROM `#__extensions`
			WHERE `type`='plugin' and `folder`='$pluginFolder' and `element`='$pluginName'";

		$currentPlugin = $db->setQuery($query)->loadObject();

		if (!$currentPlugin) {
					$app->enqueueMessage("The plugin $pluginName was not found", 'error');
			return false;
		}
		$currentPlugin->enabled = 1;

		$resultUpdate = $db->updateObject('#__extensions', $currentPlugin, ['extension_id']);
		if ($resultUpdate) {
			$app->enqueueMessage(sprintf("The plugin %s is now enabled", $pluginName), 'message');
		} else {
			$app->enqueueMessage(sprintf("Could not enable the plugin, please do it manually", $pluginName), 'warning');
		}
	}
}
