<?php
/**
 * @package Stripe Button System plugin
 * @author Riccardo Zorn code@fasterjoomla.com
 * @Copyright (C) 2012 https://www.fasterjoomla.com
 * @license GNU/GPL v2 or greater http://www.gnu.org/licenses/gpl-2.0.html
 */

defined('_JEXEC') or die;
use Joomla\CMS\Factory;

// http://docs.joomla.org/J2.5:Managing_Component_Updates_%28Script.php%29

class PlgSystemStripe_buttonInstallerScript
{
	function postflight( $type, $parent ) {
		if ( ($type == 'install' || $type == 'update') ) {
			$manifest = JPATH_SITE . '/plugins/system/stripe_button/stripe_button.xml';
			$app = Factory::getApplication();
				// let's see if the plugin is really installed:
					// the manifest contains the string:
					// <version>1.8.6</version>

			if (file_exists($manifest)) {
				if ( ($type == 'install') ) {
						return $this->enablePlugin('stripe_button', 'system');
				} else if ( ($type == 'update') ) {
							return true;//$this->enablePlugin('stripe_button', 'system');
				}
			} else {
				$app->enqueueMessage("Plugin System Stripe Button not found");
				return false;
			}
		}
	}

	/**
	 * Move $newPluginName just before $nextPluginName
	 *
	 * @param [type] $newPluginName
	 * @param [type] $pluginFolder
	 * @param [type] $nextPluginName
	 * @param [type] $reportOnly => don't move, just print status and warnings
	 * @return void
	 */
	
	function enablePlugin($pluginName, $pluginFolder) {
		$app = Factory::getApplication();
		$db = Factory::getDbo();
		$query = "select * FROM `#__extensions`
			WHERE `type`='plugin' and `folder`='$pluginFolder' and `element`='$pluginName'";
		
		$currentPlugin = $db->setQuery($query)->loadObject();
		
		if (!$currentPlugin) {
					$app->enqueueMessage("The plugin $pluginName was not found", 'error');
			return false;
		}
		$currentPlugin->enabled = 1;
			
		$resultUpdate = $db->updateObject('#__extensions', $currentPlugin, ['extension_id']);
		if ($resultUpdate) {
			$app->enqueueMessage(sprintf("The plugin %s is now enabled", $pluginName), 'message');
		} else {
			$app->enqueueMessage(sprintf("Could not enable the plugin, please do it manually", $pluginName), 'warning');
		}
	}
}
